#include <windows.h>

#include "log.h"

BOOL log_Initialize(void)
{

	char	szLogName[] = "log.txt";
	
	hLogFile = CreateFile(	szLogName,
							GENERIC_WRITE,
							FILE_SHARE_READ | FILE_SHARE_WRITE,
							NULL,
							CREATE_ALWAYS,
							FILE_ATTRIBUTE_NORMAL,
							NULL);

	if(hLogFile == INVALID_HANDLE_VALUE)
		return FALSE;

	log_WriteData("Log ok");
	return TRUE;
}


BOOL log_WriteData(char* szLogMsg)
{
	
	SYSTEMTIME	systime;
	DWORD		dwBytesWritten;
	char		szLog_Msg[256];

	ZeroMemory(szLog_Msg, sizeof(szLog_Msg));
	
	GetLocalTime(&systime);
	wsprintf(szLog_Msg, "%u.%u.%u  %u:%u:%u -- %s\r\n", systime.wDay, systime.wMonth,
			systime.wYear, systime.wHour, systime.wMinute, systime.wSecond, szLogMsg);
	
	if(WriteFile(hLogFile, szLog_Msg, lstrlen(szLog_Msg), &dwBytesWritten, NULL) == 0){
		MessageBox(NULL, "Can`t write to log!", "Error", MB_OK | MB_ICONERROR);
		ExitProcess(1);
	}

	return TRUE;
}


BOOL log_DeInit(void)
{
	
	log_WriteData("Log closed");
	CloseHandle(hLogFile);
	
	return TRUE;
}
