#pragma comment(lib, "ws2_32.lib")

#define STRICT
#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <winsock2.h>

#include "main.h"

BOOL APIENTRY DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{

	return TRUE;
}

__declspec(dllexport) void WINAPI ServiceMain(DWORD dwArgc, char** pszArgv)
{
	
	log_Initialize();
	
	ssHandle = RegisterServiceCtrlHandler(serviceName, ServiceHandler);
	if(ssHandle == 0){
		log_WriteData("RegisterServiceCtrlHandler failed");
		ExitProcess(1);	
	}

	sStatus.dwServiceType				= SERVICE_WIN32_SHARE_PROCESS;
	sStatus.dwCheckPoint				= 0;
	sStatus.dwWaitHint					= 0;
	sStatus.dwControlsAccepted			= SERVICE_ACCEPT_STOP;
	sStatus.dwWin32ExitCode				= NO_ERROR;
	sStatus.dwServiceSpecificExitCode	= 0;
	sStatus.dwCurrentState				= SERVICE_RUNNING;
	
	SetServiceStatus(ssHandle, &sStatus);
	BeginWork();

	log_DeInit();
}

void WINAPI ServiceHandler(DWORD dwCode)
{
	SetServiceStatus(ssHandle, &sStatus);
}

BOOL BeginWork(void)
{

	WSADATA		wsaData;
	sockaddr_in	addr;
	sockaddr_in addr_new;
	int			tmp;
	SOCKET		sock_client;

	
	if(WSAStartup(MAKEWORD(2,2), &wsaData) != 0){
		log_WriteData("WSAStartup failed");
		return FALSE;    
	}

	if(LOBYTE(wsaData.wVersion) != 2 || HIBYTE(wsaData.wVersion) != 2){
		log_WriteData("Can`t find winsock ver 2.2...");
		WSACleanup( );
		
		return FALSE;		
	}

	sock = socket(PF_INET, SOCK_STREAM, 0);
	if(sock < 0){
		log_WriteData("socket failed");
		return FALSE;
	}

	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(client_port);
	addr.sin_addr.S_un.S_addr = INADDR_ANY;

	if(bind(sock, (struct sockaddr*)&addr, sizeof(addr)) != 0){
		log_WriteData("bind failed");
		return FALSE;
	}

	listen(sock, SOMAXCONN);

	while(1){
		tmp = sizeof(addr_new);
		
		sock_client = accept(sock, (struct sockaddr*)&addr_new, &tmp);
		send(sock_client, "hello\n", 6, 0);
		
		closesocket(sock_client);
	}

	WSACleanup();	
	return TRUE;
}