/*

  based on our peer-2-peer 'Phoenix net' protocol

 Tested under:
   Linux 2.4.3-mdk
   Debian Linux 3.0
   FreeBSD 5.0-RELEASE

   (c) russian underground community

*/

#include <stdio.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <time.h>
#include <fcntl.h>

#include "config.h"
#include "users_tab.h"
#include "freeway_bbs.h"

int main(int argc, char *argv[])
{
  int tst,sz,pid;
  ushort i;
  unsigned long ad;

  if (argc < 2){
    printf("%sUsage: %s <local_interface_ip>%s\n",WHITE,argv[0],NORM);
    exit(0);
  }

  /* initialization... */

  ad = inet_addr(argv[1]);
  memcpy(&addr,&ad,4);
  ad = inet_addr(_GATE);
  memcpy(&gate,&ad,4);
  con = init_sock();
  ping = 2;

  memset(&if1,0,16);      // outgoing interface
  if1.sin_family = AF_INET;
  if1.sin_addr.s_addr = inet_addr(_GATE);

#ifdef _DNS
  if1.sin_port = 53;
#else 
  if1.sin_port = 0x1337;
#endif

  time(&fox);
  write2log("\n\n\nSession begin: %s", ctime(&fox));

  packet = (char *)malloc(MAX_SCAN_PACK);
  ph = (struct phoenix_proto *)(packet+20);

  if (argc == 3){
     ping = 0;
     serv[0] = 11;
     serv[1] = 43;
     use_server();
  }


  /* okay, letz go */

  if ((pid = fork()) == 0){
    sleep(1);
    ph->uid[0] = MYID;
    ph->cmd[0] = SERV_CON;
    net_send_cmd();
  }

  signal(SIGALRM,start_server);
  alarm(10); // set timeout
  
  while(1){
    memset(packet,0,MAX_SCAN_PACK);

#ifdef _ICMP_ECHO
      sz = recv(con, packet, MAX_SCAN_PACK, 0);
      if (sz < 28 || ph->uid[0] == MYID) continue;
#endif

#ifdef _DNS
      sz = recv(con, packet, 350, 0);
      if (sz < 300 || ph->uid[0] == MYID) continue;
#endif
    
      if (ph->cmd[0] == SERV_OK || ph->cmd[0] == SERV_BAK){
         serv[0] = ph->src[0];
         serv[1] = ph->arg[0];
         signal(SIGALRM,SIG_IGN);
         kill(pid,9);
         printf("%sNOTICE: %sgot reply from server!\n",YELLOW,WHITE);
         write2log("NOTICE: got reply from server (%i)\n",serv[0]);
         use_server();
      }

      if (ph->cmd[0] == SERV_ERR){
         printf("%sWARNING: %shmm.. maybe bad uid?%s\n",RED,WHITE,NORM);
         close(con);
         fclose(logfile);
         kill(pid,9);
         exit(1);
      }

  } // end of while()

}


// hvis luset tar oss!
void start_server()
{
  int i,sz,offs,fd, fl;
  fd_set ioz;
  unsigned char t[1],a[1];

  printf("%sNOTICE: %snow you are server\n",YELLOW,WHITE);
  time(&fox);
  write2log("NOTICE: now you are server \t\t%s",ctime(&fox));
  ping = 0;
  memset(&serv,0,2);

  free(packet);
  packet = (char *)malloc(MAX_PACKET_SIZE);
  ph = (struct phoenix_proto *)(packet + 20);

#ifdef _ICMP_ECHO
  text = (char *)(packet + 28);
#endif

#ifdef _DNS
  text = (char *)(packet + HDR_SIZE);
#endif

  while(1){
    FD_ZERO(&ioz);
    FD_SET(0,&ioz);
    FD_SET(con,&ioz);

    memset(packet,0,MAX_PACKET_SIZE);
    memset(&buf,0,MAX_MESG_SIZE);

    if ((sz = select(con+1, &ioz, 0, 0, 0)) < 0){
       if (sz != -4){ perror("fuck on select "); fclose(logfile); close(con); exit(1); }
    }


    if (FD_ISSET(0,&ioz)){

      sz = read(0,&buf,MAX_MESG_SIZE);

      if (buf[0] == 0x2f){
         write2log("%s",buf);
         check_cmd();
      } else {

        for (i=1; sz > 1 && i< USERS_CNT; i++){
          if (usr_list[i].kaddr[0] == 0 || i == MYID) continue;
            ph->uid[0] = MYID;
            ph->arg[0] = 0;
            ph->src[0] = usr_list[i].kaddr[0];
            net_send(&buf, strlen(buf)-1);
        }

          mesg2log("\x3c%s\x3e %s",usr_list[MYID].nick, buf);
      }
    }


    if (!FD_ISSET(con,&ioz)) continue;
    memset(packet,0,MAX_PACKET_SIZE);

#ifdef _ICMP_ECHO

    sz = recv(con, packet, MAX_PACKET_SIZE, 0);
    if (sz < 28 || ph->uid[0] == MYID) continue;

#endif

#ifdef _DEBUG

    if (ph->uid[0] == MYID || memcmp(packet+12,&addr,4) != 0
     || ph->type[0] != 8) continue;

#endif

    if (ph->cmd[0] > 0){

      /* on SERV_PING or SERV_PRP ... */

      if (ph->cmd[0] == SERV_PING || ph->cmd[0] == SERV_PRP){
        ph->uid[0] = MYID;
        ph->cmd[0] = SERV_OK;
        net_send_cmd();
        continue;
      }


      /***  FILE TRANSFER CRUFT ***/

      if (ph->cmd[0] == SERV_DATA && uploader == 2){

        fd = open((char *)&file_2_send, O_WRONLY | O_CREAT);

        if (fd <= 0){
          perror("fuck on open");
          uploader = 0;
          memset(&file_2_send,0,256);
          continue;
        }

        printf("accept block %i\n",(sz - 28));
        lseek(fd, 0, SEEK_END);
        write(fd, text, sz - 28);
        close(fd);

        continue;
      }


      if (ph->cmd[0] == SERV_FILE && uploader == 0 && sz == 28){

        ph->uid[0] = MYID;

        if (uploader == 2){
          ph->cmd[0] = SERV_ERR;
          ph->arg[0] = UPLOAD_BUSY;
          net_send_cmd();
        }

        printf(" File upload request form %s\n",usr_list[ph->uid[0]].nick);
        write(1,"accept? [y/n]: ",15);
        read(0,&t,2);

        if (t[0] != 0x79){
          ph->cmd[0] = SERV_ERR;
          ph->arg[0] = UPLOAD_DENY;
          net_send_cmd();
          continue;
        }

        write(1,"save file as: ",13);
        memset(&file_2_send,0,256);
        read(0,&file_2_send,256);
        file_2_send[strlen(file_2_send)-1] = 0;
        ph->cmd[0] = SERV_FILE;

        net_send_cmd(); // sending accept-packet

        uploader = 2;
        continue;
      }


      if (ph->cmd[0] == SERV_ERR && uploader == 1){
        printf("%sNOTICE: %sremote user rejects file transfer\n",YELLOW,WHITE);
        uploader = 0;
      }

      if (ph->cmd[0] == SERV_ERR && uploader == 2){

        if (ph->arg[0] == UPLOAD_FLER){
          printf("file not finded on remote machine!\n");
          uploader = 0;
          memset(&file_2_send,0,256);
          continue;
        }

        if (ph->arg[0] == UPLOAD_DONE){
          printf("file recived done!\n");
          uploader = 0;
          continue;
        }

      }



      if (ph->cmd[0] == SERV_FILE && uploader == 1){
        printf("%sNOTICE: %sstart sending file %s to user %s\n",
          YELLOW, WHITE, file_2_send, usr_list[ph->uid[0]].nick);

        fd = open((char *)&file_2_send,O_RDONLY);
        ph->uid[0] = MYID;

        if (fd < 0){
          perror("cant read file ");
          uploader = 0;
          memset(&file_2_send,0,256);

          ph->cmd[0] = SERV_ERR;
          ph->arg[0] = UPLOAD_FLER;
          net_send_cmd();
          continue;
        }

        memset(&f_buf, 0, MAX_FILE_SEGMENT);
        ph->cmd[0] = SERV_DATA;

        while ((fl = read(fd, &f_buf, MAX_FILE_SEGMENT)) > 0){
 
          printf("sending data block %i\n",fl);
          net_send(&f_buf, fl);
          memset(&f_buf, 0, MAX_FILE_SEGMENT);

        }

        close(fd);
        printf("%sfile transmiton done!%s\n",GREEN,WHITE);
        uploader = 0;

       	sleep(1);
       	ph->cmd[0] = SERV_ERR;
       	ph->arg[0] = UPLOAD_DONE;
       	net_send_cmd();
        continue;
      }

      /***                     ****/


      /* on SERV_WHOZ ... */

     	if (ph->cmd[0] == SERV_WHOZ){

	       memset(&buf,0,2*USERS_CNT);

        offs = 0;
	       for (i=1; i < USERS_CNT; i++){
     	    if (usr_list[i].kaddr[0] == 0) continue;
    	     buf[offs] = i;
	         buf[offs+1] = usr_list[i].kaddr[0];
	         offs+=2;
    	   }

        buf[offs] = MYID;
    	   buf[offs+1] = addr[3];
        offs += 2;

        ph->uid[0] = MYID;
    	   ph->cmd[0] = SERV_WHOZ;
        net_send(&buf, offs);
     	}


      /* on SERV_CON ... */

      if (ph->cmd[0] == SERV_CON){

        if (ph->uid[0] > USERS_CNT){

      	   ph->uid[0] = 0;
          ph->cmd[0] = SERV_ERR;
          ph->arg[0] = 0;
          net_send_cmd();
          continue;

        }

        if (serv[1] == 0){

          serv[1] = ph->src[0];
          usr_list[ph->uid[0]].kaddr[0] = ph->src[0];
          printf("%s* %s has joined%s\n",GREEN, usr_list[ph->uid[0]].nick,WHITE);
          write2log("* %s has joined\n",usr_list[ph->uid[0]].nick);
          ph->uid[0] = MYID;
          ph->cmd[0] = SERV_BAK;
          ph->arg[0] = serv[1];
          net_send_cmd();
          continue;

        }

#ifdef _DEBUG
        if (usr_list[ph->uid[0]].kaddr[0] != 0) continue;
#endif

        usr_list[ph->uid[0]].kaddr[0] = ph->src[0];
        printf("%s* %s has joined%s\n",GREEN, usr_list[ph->uid[0]].nick,WHITE);
        write2log("* %s has joined\n",usr_list[ph->uid[0]].nick);

        for (i=0; i < USERS_CNT; i++){
      	   if (usr_list[i].kaddr[0] != 0 && i != MYID && i != ph->uid[0]){
            ph->src[0] = usr_list[i].kaddr[0];
            ph->cmd[0] = SERV_JOIN;
            ph->arg[0] = ph->uid[0];
	           ph->uid[0] = MYID;
            net_send_cmd();
      	   }
        }

        ph->src[0] = usr_list[ph->uid[0]].kaddr[0];
        ph->uid[0] = MYID;
        ph->cmd[0] = SERV_OK;
        ph->arg[0] = serv[1];
        net_send_cmd();

        continue;
      }


      /* on SERV_FUCK ... */

      if (ph->cmd[0] == SERV_FUCK){
        usr_list[ph->uid[0]].kaddr[0] = 0;
        printf("%s* %s has quit %s\n",PURPLE,usr_list[ph->uid[0]].nick,WHITE);
        write2log("* %s has quit\n",usr_list[ph->uid[0]].nick);

        for (i=0; i < USERS_CNT; i++){

          if (usr_list[i].kaddr[0] != 0 && i != MYID && i != ph->uid[0]){
            ph->cmd[0] = SERV_PART;
       	    ph->src[0] = usr_list[i].kaddr[0];
            net_send_cmd();
       	  }

        }

        continue;
      }

    }

    if (ph->cmd[0] == 0){

      ph->cmd[0] = SERV_OK;
      a[0] = ph->arg[0]; // store argz
      ph->arg[0] = 0;
      t[0] = ph->uid[0]; // we need store old uid
      ph->uid[0] = MYID;
      net_send_cmd();
      ph->uid[0] = t[0];
      ph->arg[0] = a[0];

      for (i=1; i< USERS_CNT; i++){
        if (i == t[0] || i == MYID || usr_list[i].kaddr[0] == 0) continue;
       	ph->src[0] = usr_list[i].kaddr[0];
#ifdef _DNS
        net_send(text, ph->datalen[0]);
#else
        net_send(text, strlen(text));
#endif
      }

      if (a[0] == 0x0a){
        printf("%s\x3c%s%s%s\x3e%s %s%s\n", GREY, MILK, usr_list[t[0]].nick,
	           GREY,RED,text,WHITE);
    	   mesg2log("\x3c%s\x3e _WARNING_ %s\n",usr_list[t[0]].nick, text);

      } else {
	       printf("%s\x3c%s%s%s\x3e%s %s\n", GREY, MILK, usr_list[t[0]].nick,
     	           GREY,WHITE,text);
        mesg2log("\x3c%s\x3e %s\n", usr_list[t[0]].nick, text);
      }

      continue;
    }
  }

}



void on_timeout()
{
  printf("%sNOTICE: %stimeout...\n",YELLOW,WHITE);

  if (serv[1] == 0 || serv[1] == addr[3]) start_server();
  else use_server();

  printf("fuck man...%s\n",NORM);
  close(con);
  exit(1);
}



void use_server()
{
  int i,sz,cmd,fd,fl;
  unsigned short tt;
  unsigned long offset;
  char t[2];
  fd_set ioz;

  free(packet);
  packet = (char *)malloc(MAX_PACKET_SIZE);
  ph = (struct phoenix_proto *)(packet + 20);

#ifdef _ICMP_ECHO
  text = (char *)(packet + 28);
#endif

#ifdef _DNS
  text = (char *)(packet + HDR_SIZE);
#endif

  if (ping == 2) ping = 0;
  else {
    printf("%sNOTICE: %s hop to backup server\n",YELLOW,WHITE);
    time(&fox);
    mesg2log("NOTICE: hop to backup server %i \t\t%s",ctime(&fox),serv[1]);
    serv[0] = serv[1];
    serv[1] = 0;
    signal(SIGALRM,start_server);
    ph->src[0] = serv[0];
    ph->arg[0] = 0;
    ph->uid[0] = MYID;
    ph->cmd[0] = SERV_PRP;
    net_send_cmd();
    alarm(MAX_TIMEOUT);
    ph->cmd[0] = SERV_CON;
    net_send_cmd();
  }


  while(1){

    FD_ZERO(&ioz);
    FD_SET(0,&ioz);
    FD_SET(con,&ioz);

    if ((sz = select(con+1, &ioz, 0, 0, 0)) < 0){
      if (sz != -4){
        perror("fuck on select ");
        fclose(logfile);
        close(con);
        exit(1);
      }
    }

    if (FD_ISSET(0, &ioz)){
      memset(&buf,0,MAX_MESG_SIZE);

      sz = read(0,&buf,sizeof(buf));
      if (sz < 0 && sz != -11 && sz != -4){
        printf("bad ioz!\n");
       	close(con);
        fclose(logfile);
        exit(1);
      }

      if (sz < 2) continue;

      if (buf[0] == 0x2f){
        write2log("%s",buf);
        check_cmd();
      } else {
       	ph->arg[0] = 0;
       	ph->uid[0] = MYID;
       	ph->src[0] = serv[0];
       	mesg2log("\x3c%s\x3e %s",usr_list[ph->uid[0]].nick, text);
        signal(SIGALRM,on_timeout);
        alarm(MAX_TIMEOUT);
        net_send(&buf, strlen(buf)-1);
      }
    }


    if (!FD_ISSET(con, &ioz)) continue;

    memset(packet,0,MAX_PACKET_SIZE);

#ifdef _DNS
    sz = recv(con, packet, MAX_PACKET_SIZE, 0);
    if (sz < HDR_SIZE) continue;
#endif

#ifdef _ICMP_ECHO
    sz = recv(con, packet, MAX_PACKET_SIZE, 0);
    if (sz < 28 || ph->uid[0] == MYID) continue;
#endif

#ifdef _DEBUG

    if (ph->type[0] != 8 || memcmp(packet+12,&addr,4) != 0 || 
      ph->uid[0] == MYID) continue;

#endif

    signal(SIGALRM,SIG_IGN);

    if (ph->cmd[0] == SERV_OK && ping == 1){ // if it's pong..

      ping = 0;
      printf("%s<-PONG!%s \n",RED,WHITE);
      logfile = fopen(LOGFILE,"a");
      fprintf(logfile,"<-PONG!\n");
      fclose(logfile);
      if (sz == 28 && ph->arg[0] > 0) serv[1] = ph->arg[1];
      continue;

    }

    if (ph->cmd[0] == SERV_BAK && sz == 28){
      if (ph->arg[0] > 0) serv[1] = ph->arg[0];
      continue;
    }


  /***  FILE TRANSFER CRUFT ***/

    if (ph->cmd[0] == SERV_DATA && uploader == 2){

      fd = open((char *)&file_2_send, O_WRONLY | O_CREAT);

      if (fd <= 0){
        perror("fuck on open");
        uploader = 0;
        memset(&file_2_send,0,256);
        continue;
      }

      printf("accept block %i\n",(sz - 28));
      lseek(fd, 0, SEEK_END);
      write(fd, text, sz - 28);
      close(fd);

      continue;
    }

    if (ph->cmd[0] == SERV_FILE && uploader == 0 && sz == 28){

      ph->uid[0] = MYID;

      if (uploader == 2){
        ph->cmd[0] = SERV_ERR;
        ph->arg[0] = UPLOAD_BUSY;
        net_send_cmd();
      }

      printf(" File upload request form %s\n",usr_list[ph->uid[0]].nick);
      write(1,"accept? [y/n]: ",15);
      read(0,&t,2);

      if (t[0] != 0x79){
        ph->cmd[0] = SERV_ERR;
        ph->arg[0] = UPLOAD_DENY;
        net_send_cmd();
        continue;
      }

      write(1,"save file as: ",13);
      memset(&file_2_send,0,256);
      read(0,&file_2_send,256);
      file_2_send[strlen(file_2_send)-1] = 0;
      ph->cmd[0] = SERV_FILE;

      net_send_cmd(); // sending accept-packet

      uploader = 2;
      continue;
    }

    if (ph->cmd[0] == SERV_ERR && uploader == 1){
      printf("%sNOTICE: %sremote user rejects file transfer\n",YELLOW,WHITE);
      uploader = 0;
    }

    if (ph->cmd[0] == SERV_ERR && uploader == 2){

      if (ph->arg[0] == UPLOAD_FLER){
        printf("file not finded on remote machine!\n");
        uploader = 0;
        memset(&file_2_send,0,256);
        continue;
      }

      if (ph->arg[0] == UPLOAD_DONE){
        printf("file recived done!\n");
        uploader = 0;
        continue;
      }

    }

    if (ph->cmd[0] == SERV_FILE && uploader == 1){
      printf("%sNOTICE: %sstart sending file %s to user %s\n",
         YELLOW, WHITE, file_2_send, usr_list[ph->uid[0]].nick);

      fd = open((char *)&file_2_send,O_RDONLY);
      ph->uid[0] = MYID;

      if (fd < 0){
        perror("cant read file ");
        uploader = 0;
        memset(&file_2_send,0,256);

        ph->cmd[0] = SERV_ERR;
        ph->arg[0] = UPLOAD_FLER;
        net_send_cmd();
        continue;
      }

      memset(&f_buf,0,MAX_FILE_SEGMENT);
      ph->cmd[0] = SERV_DATA;

      while ((fl = read(fd, &f_buf, MAX_FILE_SEGMENT)) > 0){

        printf("sending data block %i\n",fl);
        net_send(&f_buf, fl);
        memset(&f_buf, 0 ,MAX_FILE_SEGMENT);
      }

      close(fd);
      printf("%sfile transmiton done!%s\n",GREEN,WHITE);
      uploader = 0;
      sleep(1);
      ph->cmd[0] = SERV_ERR;
      ph->arg[0] = UPLOAD_DONE;
      net_send_cmd();
      continue;
    }

    /***                     ****/

    if (ph->cmd[0] == SERV_WHOZ && sz > 28){

      printf("%s Users online:%s\n",YELLOW,WHITE);
      for (i = 0; i< (sz-28); i+=2){
        memcpy(&t,packet+28+i,2);
     	  tt = t[1];
	       tt %= 256;
        printf("\t%s\t%i\n",usr_list[t[0]].nick, tt);
      }

      continue;
    }

    if (ph->cmd[0] == SERV_PRP){

      if (serv[1] == addr[3]){
       	ph->cmd[0] = SERV_OK;
        ph->arg[0] = 0;
       	ph->uid[0] = MYID;
        net_send_cmd();
       	printf("%sNOTICE: %sgot SERV_PRP\n",YELLOW,WHITE);
        start_server();
      }

    }

    if (ph->cmd[0] == SERV_JOIN){
      printf("%s* %s has joined%s\n", GREEN, usr_list[ph->arg[0]].nick, WHITE);
      write2log("* %s has joined\n", usr_list[ph->arg[0]].nick);
      continue;
    }


    if (ph->cmd[0] == SERV_PART){
      printf("%s* %s has quit%s\n", PURPLE, usr_list[ph->arg[0]].nick, WHITE);
      write2log("* %s has quit\n", usr_list[ph->arg[0]].nick);
      continue;
    }

    if (ph->cmd[0] == 0){

      if (ph->arg[0] == 0x0a){
        printf("%s\x3c%s%s%s\x3e%s %s%s\n",
        GREY,MILK,usr_list[ph->uid[0]].nick,GREY,RED,text,WHITE);
       	mesg2log("\x3c%s\x3e _WARNING_ %s\n",usr_list[ph->uid[0]].nick, text);
      } else {
        printf("%s\x3c%s%s%s\x3e%s %s\n",
        GREY,MILK,usr_list[ph->uid[0]].nick,GREY,WHITE,text);
      	 mesg2log("\x3c%s\x3e %s\n",usr_list[ph->uid[0]].nick, text);
      }

    }

  }
}

